
$('[name=contato_telefone]').mask('(99) 9999-9999');
$('[name=contato_celular]').mask('(99) 9 9999-9999');

$(function(){

    let nome,
        email,       
        telefone,
        mensagem,
        assunto;
    
    function validarEmail(email){ var re=/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/; return re.test(email);}
    function validarCPF(c){return/^\d{3}(\.\d{3}){2}-\d{2}$/.test(c)||/^\d{11}$/.test(c)}
     
    function contatoValues(campo = null) { 
        let nome = $('[name=contato_nome]').val();
        let email = $('[name=contato_email]').val();
        let cpf = $('[name=contato_cpf]').val();
        let telefone = $('[name=contato_telefone]').val();
        let mensagem = $('[name=contato_mensagem]').val();
        let assunto = $("[name=contato_assunto] option:checked").val();
    
        // Campos obrigatórios e suas mensagens
        const campos = [
            { name: 'nome', valor: nome, mensagem: 'Nome é obrigatório.', required: true },
            { name: 'email', valor: email, mensagem: 'Email é obrigatório.', required: true },
            { name: 'cpf', valor: cpf, mensagem: 'CPF é obrigatório.', required: false },
            { name: 'telefone', valor: telefone, mensagem: 'Telefone é obrigatório.', required: true },
            { name: 'mensagem', valor: mensagem, mensagem: 'Mensagem é obrigatória.', required: true },
            { name: 'assunto', valor: assunto, mensagem: 'Assunto é obrigatório.', required: true }
        ];
    
        // Função para validar um campo específico ou todos
        const validarCampo = (campoItem) => {
            if (campoItem.required && !campoItem.valor) {
                alert(campoItem.mensagem);
                return false;
            }
            
            if (campoItem.name === 'email' && campoItem.valor && !validarEmail(campoItem.valor)) {
                alert('Por favor, insira um e-mail válido.');
                return false;
            }
            
            if (campoItem.name === 'cpf' && campoItem.valor && !validarCPF(campoItem.valor)) {
                alert('Por favor, insira um CPF válido (11 dígitos ou com pontos e traço).');
                return false;
            }
    
            return true;
        };
    
        // Se um campo específico for passado, valida apenas esse campo
        if (campo) {
            const campoItem = campos.find(c => c.name === campo);
            if (campoItem && !validarCampo(campoItem)) return false;
        } else {
            // Caso contrário, valida todos os campos
            for (let i = 0; i < campos.length; i++) {
                if (!validarCampo(campos[i])) return false;
            }
        }
    
        // Retorna os valores dos campos após a validação
        return { nome, email, telefone, assunto, mensagem }; 
    }    
      


    $('form#contato_form').on('submit', function(event){
        event.preventDefault();
        campos = contatoValues();
        
        if(campos){
            $.ajax('https://api-public.madnezz.com.br/api/v1/public/sites/contato?api_token='+shopping_id, {
                data:{
                    "tk": shopping_token,
                    "cpf": "",
                    "telefone": campos.telefone,
                    "celular": "",
                    "cep": "",
                    "email": campos.email,
                    "nome": campos.nome,
                    "assunto": campos.assunto,
                    "mensagem": campos.mensagem,
                    "validaemail": "",
                    "sendmail": true,
                    "reply": true
                },
                type:'POST',
                dataType:'json'
            }).then(function (data){
                switch (data.status){
                    case "done":
                        alert("Mensagem enviada com sucesso");
						setTimeout(() => {
							location.reload();
						}, 2000);
                        break;
                    case "captcha-wrong-code":
                        alert("O código do captcha é inválido, digite novamente");
                        break;
                    case "captcha-expired":
                        alert("O código do captcha já foi usado, tente novamente");
                        break;
                }
            }).fail(function () {
                alert("Ocorreu um erro ao enviar os dados.");
            });
        }
    })
});